from PyQt5.QtWidgets import (
    QDialog, QVBoxLayout, QLabel, QComboBox, QLineEdit,
    QPushButton, QMessageBox, QFormLayout, QCompleter
)
import sqlite3
import os

CAMINHO_BANCO = os.path.join("db", "sistema_financeiro.db")

class DialogNovoMedico(QDialog):
    def __init__(self, parent=None, nomes_existentes=None):
        super().__init__(parent)
        self.setWindowTitle("Cadastrar Novo Médico")
        self.setMinimumWidth(400)

        layout = QVBoxLayout(self)
        form_layout = QFormLayout()

        self.combo_nome = QComboBox()
        self.combo_nome.setEditable(True)
        nomes_unicos = sorted(set(nomes_existentes or []))
        self.combo_nome.addItems(["Novo Médico"] + nomes_unicos)

        completer = QCompleter(nomes_unicos, self)
        completer.setCaseSensitivity(False)
        self.combo_nome.setCompleter(completer)
        self.combo_nome.currentIndexChanged.connect(self.verificar_se_novo)

        self.input_nome_novo = QLineEdit()
        self.input_nome_novo.setPlaceholderText("Digite o nome do novo médico")

        self.input_crm = QLineEdit()
        self.input_crm.setPlaceholderText("Ex: 123456/MG")

        self.input_rqe = QLineEdit()
        self.input_rqe.setPlaceholderText("Ex: 98765")

        self.input_especialidade = QLineEdit()
        self.input_especialidade.setPlaceholderText("Ex: Cardiologia")

        form_layout.addRow("Nome:", self.combo_nome)
        form_layout.addRow("Novo Nome:", self.input_nome_novo)
        form_layout.addRow("CRM:", self.input_crm)
        form_layout.addRow("RQE:", self.input_rqe)
        form_layout.addRow("Especialidade:", self.input_especialidade)

        self.btn_salvar = QPushButton("Salvar Médico")
        self.btn_salvar.clicked.connect(self.salvar_medico)

        layout.addLayout(form_layout)
        layout.addWidget(self.btn_salvar)

        self.verificar_se_novo()

    def verificar_se_novo(self):
        if self.combo_nome.currentText() == "Novo Médico":
            self.input_nome_novo.setEnabled(True)
            self.input_nome_novo.setFocus()
        else:
            self.input_nome_novo.setEnabled(False)
            self.input_nome_novo.clear()

    def salvar_medico(self):
        nome = self.input_nome_novo.text().strip() if self.combo_nome.currentText() == "Novo Médico" else self.combo_nome.currentText()
        crm = self.input_crm.text().strip()
        rqe = self.input_rqe.text().strip()
        esp = self.input_especialidade.text().strip()

        if not nome:
            QMessageBox.warning(self, "Atenção", "Nome do médico é obrigatório.")
            return

        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()

            # Verifica duplicidade no banco
            cursor.execute("SELECT id FROM medicos WHERE nome = ?", (nome,))
            if cursor.fetchone():
                QMessageBox.warning(self, "Atenção", f"Já existe um médico com o nome '{nome}'.")
                return

            cursor.execute(""" 
                INSERT INTO medicos (nome, crm, rqe, especialidade) 
                VALUES (?, ?, ?, ?)
            """, (nome, crm, rqe, esp))
            conn.commit()
            conn.close()

            QMessageBox.information(self, "Sucesso", f"Médico '{nome}' salvo com sucesso.")
            self.accept()
        except Exception as e:
            QMessageBox.critical(self, "Erro", f"Erro ao salvar no banco: {e}")
