import sqlite3
from PyQt5.QtWidgets import (
    QDialog, QVBoxLayout, QLabel, QTableWidget, QTableWidgetItem,
    QPushButton, QHBoxLayout
)
from PyQt5.QtCore import Qt
from gui.dialog_editar_procedimento import DialogEditarProcedimentoMedico

CAMINHO_BANCO = "db/sistema_financeiro.db"

class DialogProcedimentosMedico(QDialog):
    def __init__(self, nome_medico, parent=None):
        super().__init__(parent)
        self.setWindowTitle(f"Procedimentos de {nome_medico}")
        self.setMinimumWidth(650)
        self.nome_medico = nome_medico

        layout = QVBoxLayout(self)
        self.label = QLabel(f"Procedimentos vinculados ao Dr(a). <b>{nome_medico}</b>:")
        layout.addWidget(self.label)

        self.tabela = QTableWidget()
        self.tabela.setColumnCount(4)
        self.tabela.setHorizontalHeaderLabels(["Convênio", "Procedimento", "Valor Médico", "Editar"])
        self.tabela.verticalHeader().setVisible(False)
        self.tabela.setAlternatingRowColors(True)
        layout.addWidget(self.tabela)

        self.carregar_procedimentos()

    def carregar_procedimentos(self):
        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()

            cursor.execute("SELECT id FROM medicos WHERE nome = ?", (self.nome_medico,))
            resultado = cursor.fetchone()
            if not resultado:
                conn.close()
                return

            medico_id = resultado[0]

            cursor.execute("""
                SELECT id, convenio, procedimento, valor_medico
                FROM medico_procedimentos
                WHERE medico_id = ?
                ORDER BY convenio, procedimento
            """, (medico_id,))
            dados = cursor.fetchall()
            conn.close()

            self.tabela.setRowCount(len(dados))

            for i, row in enumerate(dados):
                proc_id, convenio, procedimento, valor = row

                self.tabela.setItem(i, 0, QTableWidgetItem(str(convenio)))
                self.tabela.setItem(i, 1, QTableWidgetItem(str(procedimento)))

                valor_str = f"R$ {float(valor):,.2f}".replace(",", "X").replace(".", ",").replace("X", ".")
                self.tabela.setItem(i, 2, QTableWidgetItem(valor_str))

                for col in range(3):
                    item = self.tabela.item(i, col)
                    if item:
                        item.setTextAlignment(Qt.AlignCenter)

                # Botão Editar (escopo isolado com lambda)
                btn_editar = QPushButton("✏️ Editar")
                btn_editar.clicked.connect(lambda _, pid=proc_id: self.abrir_edicao_procedimento(pid))
                self.tabela.setCellWidget(i, 3, btn_editar)

            self.tabela.resizeColumnsToContents()

        except Exception as e:
            print(f"[ERRO] ao carregar procedimentos do médico: {e}")

    def abrir_edicao_procedimento(self, proc_id):
        dialog = DialogEditarProcedimentoMedico(proc_id, self)
        if dialog.exec_() == QDialog.Accepted:
            self.carregar_procedimentos()
