# gui/modulo2_cadastro_medicos.py

from PyQt5.QtWidgets import (
    QWidget, QVBoxLayout, QPushButton, QHBoxLayout,
    QTableWidget, QTableWidgetItem, QMessageBox, QDialog,
    QFormLayout, QLineEdit, QComboBox, QLabel, QFileDialog,
    QDialogButtonBox
)

from gui.dialog_novo_medico import DialogNovoMedico
from gui.dialog_incluir_procedimento import DialogIncluirProcedimento
from gui.dialog_procedimentos_medico import DialogProcedimentosMedico
import sqlite3
import os
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QCompleter
from PyQt5.QtWidgets import QFormLayout
from PyQt5.QtWidgets import (
    QWidget, QVBoxLayout, QPushButton, QHBoxLayout,
    QTableWidget, QTableWidgetItem, QMessageBox, QDialog,
    QHeaderView, QFrame
)
from PyQt5.QtCore import Qt
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QLineEdit
import pandas as pd
from PIL import Image
import re

CAMINHO_BANCO = os.path.join("db", "sistema_financeiro.db")

class DialogSelecionarCompetencia(QDialog):
    def __init__(self):
        super().__init__()
        self.setWindowTitle("Selecionar Competência")
        self.setFixedSize(300, 150)

        layout = QFormLayout(self)
        self.combo_mes = QComboBox()
        self.combo_ano = QComboBox()

        self.combo_mes.addItems(["01", "02", "03", "04", "05", "06",
                                 "07", "08", "09", "10", "11", "12"])
        self.combo_ano.addItems(["2025", "2026", "2027", 
                                 "2028", "2029", "2030", "2031", "2032", "2033"])

        layout.addRow("Mês:", self.combo_mes)
        layout.addRow("Ano:", self.combo_ano)

        botoes = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Cancel)
        botoes.accepted.connect(self.accept)
        botoes.rejected.connect(self.reject)
        layout.addWidget(botoes)

    def get_competencia(self):
        return f"{self.combo_mes.currentText()}/{self.combo_ano.currentText()}"

class ModuloCadastroMedicos(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.parent_main = parent
        self.layout = QVBoxLayout(self)
        self.layout.setSpacing(20)
        self.layout.setContentsMargins(20, 20, 20, 20)

        # Estilo dos botões
        estilo_botao = """
            QPushButton {
                background-color: #3498db;
                color: white;
                padding: 6px 12px;
                font-weight: bold;
                border-radius: 4px;
            }
            QPushButton:hover {
                background-color: #2980b9;
            }
        """

        # Botões
        botoes_layout = QHBoxLayout()
        self.botao_novo_medico = QPushButton("➕ Novo Médico")
        self.botao_incluir_procedimentos = QPushButton("📋 Incluir Procedimentos")
        self.botao_editar_medico = QPushButton("✏️ Editar Médico")
        self.botao_duplicar_medico = QPushButton("📑 Duplicar Médico")
        self.botao_excluir_medico = QPushButton("🗑️ Excluir Médico")
        self.botao_exportar_excel = QPushButton("Exportar Excel")

        for botao in [self.botao_novo_medico, self.botao_incluir_procedimentos,
                      self.botao_editar_medico, self.botao_duplicar_medico,
                      self.botao_excluir_medico, self.botao_exportar_excel]:
            botao.setStyleSheet(estilo_botao)

        # Tooltips
        self.botao_novo_medico.setToolTip("Cadastrar um novo médico")
        self.botao_incluir_procedimentos.setToolTip("Vincular procedimentos ao médico selecionado")
        self.botao_editar_medico.setToolTip("Editar os dados do médico")
        self.botao_duplicar_medico.setToolTip("Duplicar os procedimentos do médico selecionado")
        self.botao_excluir_medico.setToolTip("Excluir médico e procedimentos vinculados")
        self.botao_exportar_excel.setToolTip("Exportar Tabela do médico")

        self.botao_novo_medico.clicked.connect(self.abrir_modal_novo_medico)
        self.botao_incluir_procedimentos.clicked.connect(self.abrir_modal_incluir_procedimento)
        self.botao_editar_medico.clicked.connect(self.abrir_modal_editar_medico)
        self.botao_duplicar_medico.clicked.connect(self.abrir_modal_duplicar_medico)
        self.botao_excluir_medico.clicked.connect(self.excluir_medico)
        self.botao_exportar_excel.clicked.connect(self.exportar_excel)        

        # Adicionar botões
        botoes_layout.addWidget(self.botao_novo_medico)
        botoes_layout.addWidget(self.botao_incluir_procedimentos)
        botoes_layout.addWidget(self.botao_editar_medico)
        botoes_layout.addWidget(self.botao_duplicar_medico)
        botoes_layout.addWidget(self.botao_excluir_medico)
        botoes_layout.addWidget(self.botao_exportar_excel)

        # Campo de busca por nome do médico
        filtro_layout = QHBoxLayout()
        self.campo_busca = QLineEdit()
        self.campo_busca.setPlaceholderText("🔍 Buscar por nome do médico...")
        self.campo_busca.textChanged.connect(self.filtrar_medicos)
        filtro_layout.addWidget(self.campo_busca)
        self.layout.addLayout(botoes_layout)

        # Separador visual
        linha_divisoria = QFrame()
        linha_divisoria.setFrameShape(QFrame.HLine)
        linha_divisoria.setFrameShadow(QFrame.Sunken)
        self.layout.addWidget(linha_divisoria)

        

        # Tabela de Médicos
        self.tabela = QTableWidget()
        self.tabela.setColumnCount(4)
        self.tabela.setHorizontalHeaderLabels(["Nome", "CRM", "RQE", "Especialidade"])
        self.tabela.verticalHeader().setVisible(False)
        self.tabela.setSortingEnabled(True)
        self.tabela.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)
        self.tabela.cellDoubleClicked.connect(self.abrir_modal_procedimentos_medico)

        # Layout final
        self.layout.addLayout(filtro_layout)
        self.layout.addWidget(linha_divisoria)
        self.layout.addWidget(self.tabela)

        # Carregar dados iniciais
        self.carregar_medicos()

    def abrir_modal_duplicar_medico(self):
        from PyQt5.QtWidgets import (
            QDialog, QVBoxLayout, QLabel, QComboBox, QPushButton,
            QHBoxLayout, QMessageBox, QFormLayout
        )
        from PyQt5.QtGui import QIcon
        from PyQt5.QtCore import Qt
        from PyQt5.QtWidgets import QCompleter
        from gui.dialog_novo_medico import DialogNovoMedico
        import sqlite3

        selected_row = self.tabela.currentRow()
        if selected_row < 0:
            QMessageBox.warning(self, "Atenção", "Selecione um médico para duplicar.")
            return

        nome_origem = self.tabela.item(selected_row, 0).text()

        dialog = QDialog(self)
        dialog.setWindowTitle("Duplicar Médico")
        dialog.setMinimumWidth(420)

        layout = QFormLayout(dialog)
        layout.setSpacing(12)
        layout.setContentsMargins(20, 20, 20, 20)

        layout.addRow(QLabel(f"<b>Duplicar procedimentos de:</b> {nome_origem}"))

        # Combo e botão lado a lado
        combo_nomes = QComboBox()
        combo_nomes.setEditable(True)
        btn_novo_medico = QPushButton("+ Novo Médico")
        linha_combo = QHBoxLayout()
        linha_combo.addWidget(combo_nomes)
        linha_combo.addWidget(btn_novo_medico)
        layout.addRow("Novo médico:", linha_combo)

        # Buscar nomes de médicos da tabela registros_financeiros
        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()
            cursor.execute("""
                SELECT DISTINCT "Médico" FROM registros_financeiros
                WHERE "Médico" IS NOT NULL AND TRIM("Médico") != '' AND "Médico" != ?
                ORDER BY "Médico"
            """, (nome_origem,))
            nomes_existentes = [row[0] for row in cursor.fetchall()]
            conn.close()
            combo_nomes.addItems(nomes_existentes)

            completer = combo_nomes.completer()
            completer.setFilterMode(Qt.MatchContains)
            completer.setCompletionMode(QCompleter.PopupCompletion)

        except Exception as e:
            QMessageBox.critical(self, "Erro", f"Erro ao buscar nomes dos médicos:\n{e}")
            return

        # Botões duplicar/cancelar
        botoes_layout = QHBoxLayout()
        btn_duplicar = QPushButton("Duplicar")
        btn_cancelar = QPushButton("Cancelar")

        btn_duplicar.setStyleSheet("background-color: #4CAF50; color: white; padding: 6px 12px; font-weight: bold;")
        botoes_layout.addStretch()
        botoes_layout.addWidget(btn_duplicar)
        botoes_layout.addWidget(btn_cancelar)
        layout.addRow(botoes_layout)
        

        def abrir_novo_medico():
            novo_dialog = DialogNovoMedico(self)
            if novo_dialog.exec_() == QDialog.Accepted:
                try:
                    conn = sqlite3.connect(CAMINHO_BANCO)
                    cursor = conn.cursor()
                    cursor.execute("""
                        SELECT nome FROM medicos
                        WHERE nome != ?
                        ORDER BY nome
                    """, (nome_origem,))
                    novos_nomes = [row[0] for row in cursor.fetchall()]
                    conn.close()
                    combo_nomes.clear()
                    combo_nomes.addItems(novos_nomes)
                    combo_nomes.setCurrentText(novos_nomes[-1])
                except Exception as e:
                    QMessageBox.warning(self, "Erro", f"Erro ao atualizar lista de médicos:\n{e}")

        btn_novo_medico.clicked.connect(abrir_novo_medico)
        btn_duplicar.clicked.connect(lambda: dialog.accept())
        btn_cancelar.clicked.connect(dialog.reject)

        if dialog.exec_() != QDialog.Accepted:
            return

        novo_nome = combo_nomes.currentText().strip()
        if not novo_nome:
            QMessageBox.warning(self, "Atenção", "Nenhum nome selecionado.")
            return

        # Duplicar dados
        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()

            cursor.execute("SELECT crm, rqe, especialidade FROM medicos WHERE nome = ?", (nome_origem,))
            dados_medico = cursor.fetchone()
            if not dados_medico:
                QMessageBox.warning(self, "Erro", "Médico original não encontrado.")
                return

            cursor.execute("SELECT id FROM medicos WHERE nome = ?", (novo_nome,))
            existe = cursor.fetchone()
            if existe:
                novo_id = existe[0]
            else:
                cursor.execute("""
                    INSERT INTO medicos (nome, crm, rqe, especialidade)
                    VALUES (?, ?, ?, ?)
                """, (novo_nome, *dados_medico))
                novo_id = cursor.lastrowid

            cursor.execute("SELECT id FROM medicos WHERE nome = ?", (nome_origem,))
            origem_id = cursor.fetchone()[0]

            cursor.execute("""
                SELECT convenio, procedimento, valor_medico
                FROM medico_procedimentos
                WHERE medico_id = ?
            """, (origem_id,))
            procedimentos = cursor.fetchall()

            for convenio, procedimento, valor in procedimentos:
                cursor.execute("""
                    INSERT INTO medico_procedimentos (medico_id, convenio, procedimento, valor_medico)
                    VALUES (?, ?, ?, ?)
                """, (novo_id, convenio, procedimento, valor))

            conn.commit()
            conn.close()

            QMessageBox.information(self, "Sucesso", f"Procedimentos duplicados para '{novo_nome}'.")
            self.carregar_medicos()

        except Exception as e:
            QMessageBox.critical(self, "Erro", f"Erro ao duplicar médico:\n{e}")

    def filtrar_medicos(self):
            texto = self.campo_busca.text().lower()
            for row in range(self.tabela.rowCount()):
                item_nome = self.tabela.item(row, 0)  # Coluna "Nome"
                if item_nome and texto in item_nome.text().lower():
                    self.tabela.setRowHidden(row, False)
                else:
                    self.tabela.setRowHidden(row, True)


    def abrir_modal_editar_medico(self):
        from gui.dialog_editar_medico import DialogEditarMedico
        selected_row = self.tabela.currentRow()
        if selected_row < 0:
            QMessageBox.warning(self, "Atenção", "Selecione um médico na tabela.")
            return
        nome_medico = self.tabela.item(selected_row, 0).text()
        dialog = DialogEditarMedico(nome_medico, self)
        if dialog.exec_() == QDialog.Accepted:
            self.carregar_medicos()

    def abrir_modal_procedimentos_medico(self, row, column):
        nome_medico = self.tabela.item(row, 0).text()
        dialog = DialogProcedimentosMedico(nome_medico, self)
        dialog.exec_()

    def abrir_modal_novo_medico(self):        
        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()
            cursor.execute("""
                SELECT DISTINCT "Médico" FROM registros_financeiros
                WHERE "Médico" IS NOT NULL AND TRIM("Médico") != ''
                ORDER BY "Médico"
            """)
            nomes_existentes = [row[0] for row in cursor.fetchall()]
            conn.close()

            dialog = DialogNovoMedico(self, nomes_existentes)
            if dialog.exec_() == QDialog.Accepted:
                self.carregar_medicos()
        except Exception as e:
            QMessageBox.critical(self, "Erro", f"Erro ao abrir modal de novo médico:\n{e}")



    def abrir_modal_incluir_procedimento(self):
        selected_row = self.tabela.currentRow()
        if selected_row < 0:
            QMessageBox.warning(self, "Atenção", "Selecione um médico na tabela.")
            return
        nome_medico = self.tabela.item(selected_row, 0).text()
        dialog = DialogIncluirProcedimento(nome_medico, self)
        dialog.exec_()

    def excluir_medico(self):
        selected_row = self.tabela.currentRow()
        if selected_row < 0:
            QMessageBox.warning(self, "Atenção", "Selecione um médico na tabela.")
            return

        nome_medico = self.tabela.item(selected_row, 0).text()
        confirm = QMessageBox.question(
            self,
            "Confirmar Exclusão",
            f"Tem certeza que deseja excluir o médico '{nome_medico}' e todos os procedimentos vinculados?",
            QMessageBox.Yes | QMessageBox.No
        )
        if confirm == QMessageBox.Yes:
            try:
                conn = sqlite3.connect(CAMINHO_BANCO)
                cursor = conn.cursor()
                cursor.execute("SELECT id FROM medicos WHERE nome = ?", (nome_medico,))
                result = cursor.fetchone()
                if not result:
                    QMessageBox.warning(self, "Aviso", "Médico não encontrado.")
                    return
                medico_id = result[0]

                cursor.execute("DELETE FROM medico_procedimentos WHERE medico_id = ?", (medico_id,))
                cursor.execute("DELETE FROM medicos WHERE id = ?", (medico_id,))
                conn.commit()
                conn.close()

                QMessageBox.information(self, "Sucesso", f"Médico '{nome_medico}' excluído com sucesso.")
                self.carregar_medicos()
            except Exception as e:
                QMessageBox.critical(self, "Erro", f"Erro ao excluir médico:\n{e}")

    def carregar_medicos(self):
        from PyQt5.QtCore import Qt
        self.tabela.setRowCount(0)
        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            cursor = conn.cursor()
            cursor.execute("SELECT nome, crm, rqe, especialidade FROM medicos ORDER BY nome")
            medicos = cursor.fetchall()
            conn.close()

            self.tabela.setRowCount(len(medicos))
            for i, row in enumerate(medicos):
                for j, valor in enumerate(row):
                    item = QTableWidgetItem(str(valor))
                    item.setTextAlignment(Qt.AlignCenter)
                    self.tabela.setItem(i, j, item)
        except Exception as e:
            print(f"[ERRO] ao carregar médicos: {e}")

    

    def exportar_excel(self):
        selected = self.tabela.currentRow()
        if selected < 0:
            QMessageBox.warning(self, "Atenção", "Selecione um médico na tabela.")
            return

        nome = self.tabela.item(selected, 0).text()
        nome_somente = re.sub(r"\s*-\s*CRM.*", "", nome).strip()
        nome_maiusculo = nome_somente.upper()

        dialog = DialogSelecionarCompetencia()
        if dialog.exec_() != QDialog.Accepted:
            return
        competencia = dialog.get_competencia()

        try:
            conn = sqlite3.connect(CAMINHO_BANCO)
            df = pd.read_sql_query(
                "SELECT * FROM registros_financeiros WHERE Médico = ? AND Competência = ?",
                conn, params=(nome, competencia)
            )
            conn.close()

            if df.empty:
                QMessageBox.information(self, "Aviso", f"Nenhum registro encontrado para {nome} na competência {competencia}.")
                return

            if "Médico" in df.columns:
                df["Médico"] = df["Médico"].str.extract(r"^(.*?)(?:\s*-\s*CRM|$)")[0].str.strip()

            colunas_para_remover = ["Empresa", "Convenio", "Valor Convenio"]
            df.drop(columns=[col for col in colunas_para_remover if col in df.columns], inplace=True)

            caminho, _ = QFileDialog.getSaveFileName(
                self, "Salvar como", f"{nome_somente}_{competencia.replace('/', '-')}.xlsx", "Excel Files (*.xlsx)"
            )
            if not caminho:
                return

            colunas_visiveis = [col for col in df.columns if col not in ['Cod Registro', 'Duplicado', 'NaoDuplicadoOIT', 'Competência', 'Data Cadastro', 'Data Recebimento', 'Tipo de Exame', 'Competencia']]
            writer = pd.ExcelWriter(caminho, engine='xlsxwriter')
            workbook = writer.book
            df.to_excel(writer, index=False, sheet_name='Registros', columns=colunas_visiveis, startrow=2)
            worksheet = writer.sheets['Registros']

            azul_cabecalho = '#B7D6F4'
            header_format = workbook.add_format({'bold': True, 'bg_color': '#D9D9D9', 'border': 1, 'align': 'center', 'valign': 'vcenter'})
            center_format = workbook.add_format({'align': 'center', 'valign': 'vcenter'})
            money_format = workbook.add_format({'num_format': '"R$" #,##0.00', 'align': 'center', 'valign': 'vcenter'})
            amarelo_center = workbook.add_format({'align': 'center', 'bg_color': '#FFF59D', 'valign': 'vcenter'})
            amarelo_money = workbook.add_format({'num_format': '"R$" #,##0.00', 'align': 'center', 'bg_color': '#FFF59D', 'valign': 'vcenter'})
            verde_center = workbook.add_format({'align': 'center', 'bg_color': '#C8E6C9', 'valign': 'vcenter'})
            verde_money = workbook.add_format({'num_format': '"R$" #,##0.00', 'align': 'center', 'bg_color': '#C8E6C9', 'valign': 'vcenter'})
            bold_blue = workbook.add_format({'bold': True, 'font_color': 'black', 'bg_color': azul_cabecalho, 'border': 1, 'align': 'center'})
            bold_right = workbook.add_format({'bold': True, 'align': 'right', 'bg_color': azul_cabecalho, 'border': 1})
            value_right = workbook.add_format({'align': 'right', 'bg_color': azul_cabecalho, 'border': 1})
            money_right = workbook.add_format({'num_format': '"R$" #,##0.00', 'align': 'right', 'bg_color': azul_cabecalho, 'border': 1})
            logo_background = workbook.add_format({'bg_color': azul_cabecalho, 'border': 1})

            total_laudos = len(df)
            total_valor = df["Valor Médico"].apply(
                lambda v: float(str(v).replace("R$", "").replace(".", "").replace(",", ".")) if isinstance(v, str) else v
            ).sum()

            worksheet.merge_range("A1:A2", "", logo_background)
            worksheet.merge_range("B1:C1", f"FATURAMENTO {nome_maiusculo}", bold_blue)
            worksheet.merge_range("B2:C2", f"COMPETÊNCIA: {competencia}", bold_blue)
            worksheet.write("D1", "TOTAL", bold_right)
            worksheet.write("E1", total_valor, money_right)
            worksheet.write("D2", "LAUDOS", bold_right)
            worksheet.write("E2", total_laudos, value_right)

            caminho_logo = os.path.join("icones", "medical_laudos_logo.png")
            if os.path.exists(caminho_logo):
                worksheet.insert_image("A1", caminho_logo, {'x_scale': 0.45, 'y_scale': 0.45, 'x_offset': 2, 'y_offset': 2})

            for col_num, nome_coluna in enumerate(colunas_visiveis):
                worksheet.write(2, col_num, nome_coluna, header_format)
                largura = max(df[nome_coluna].astype(str).map(len).max(), len(nome_coluna)) + 2
                worksheet.autofilter(2, 0, 2 + len(df), len(colunas_visiveis) - 1)
                worksheet.set_column(col_num, col_num, largura)

            def str_to_bool(valor):
                return str(valor).strip().lower() in ["1", "true", "verdadeiro"]

            for row_num, row_data in df.iterrows():
                duplicado = str_to_bool(row_data.get("Duplicado", ""))
                nao_oit = str_to_bool(row_data.get("NaoDuplicadoOIT", ""))

                for col_num, nome_coluna in enumerate(colunas_visiveis):
                    valor = row_data[nome_coluna]
                    if duplicado:
                        formato = amarelo_money if nome_coluna == 'Valor Médico' else amarelo_center
                    elif nao_oit:
                        formato = verde_money if nome_coluna == 'Valor Médico' else verde_center
                    else:
                        formato = money_format if nome_coluna == 'Valor Médico' else center_format

                    linha_excel = row_num + 3
                    if nome_coluna == 'Valor Médico':
                        try:
                            valor_float = float(valor)
                            worksheet.write_number(linha_excel, col_num, valor_float, formato)
                        except:
                            worksheet.write(linha_excel, col_num, str(valor), formato)
                    else:
                        worksheet.write(linha_excel, col_num, str(valor), formato)

            writer.close()
            QMessageBox.information(self, "Sucesso", f"Arquivo exportado com sucesso para:\n{caminho}")

        except Exception as e:
            QMessageBox.critical(self, "Erro", f"Erro ao exportar Excel:\n{e}")





