import pandas as pd
import os

# Caminho relativo correto (subindo da pasta gui para a raiz do projeto)
caminho = r"C:\Users\Rafael Hissa\Desktop\projetos\Projeto_Sistema_Financeiro_Medical_Laudos\planilas_medical\marco-2025.xlsx"

# Verifica se o arquivo existe
print("Caminho absoluto esperado:")
print(os.path.abspath(caminho))
print("Existe?", os.path.exists(caminho))

# Nome das colunas esperadas
colunas_personalizadas = [
    "Cod Registro", "Data Exame", "Nome", "Empresa", "Convenio",
    "Procedimento", "Médico", "Data Cadastro", "Data Recebimento",
    "Valor Médico", "Valor Convenio"
]

# Lê a planilha sem converter nada
df = pd.read_excel(
    caminho,
    header=None,
    skiprows=2,
    names=colunas_personalizadas,
    dtype=str,
    engine='openpyxl'
)

# Mostra as 10 primeiras linhas das colunas de data
print("\n📅 Data Cadastro e Data Recebimento (brutos):")
print(df[["Data Cadastro", "Data Recebimento"]].head(11000))
